/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java;

import android.app.Application;
import android.util.Log;
import com.applovin.sdk.AppLovinMediationProvider;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.boldwin.sdk.api.BoldwinSDK;
import com.boldwin.sdk.api.utils.BoldwinInitializationStatus;
import com.boldwin.sdk.api.utils.BoldwinLogLevel;
import com.boldwin.sdk.demo.java.utils.Settings;
import com.unity3d.mediation.*;

public class CustomApplication extends Application {

    private static final String TAG = "BoldwinCustomApplication";

    @Override
    public void onCreate() {
        super.onCreate();
        initBoldwinSDK();
        initApplovinMax();
        initIronSource();
        Settings.init(this);
    }

    private void initBoldwinSDK() {
        String publisherId = "2016";
        BoldwinSDK.setLogLevel(BoldwinLogLevel.DEBUG);

        BoldwinSDK.initialize(publisherId, getApplicationContext(), status -> {
            if (status == BoldwinInitializationStatus.SUCCEEDED) {
                Log.d(TAG, "SDK initialized successfully!");
            } else {
                Log.e(TAG, "SDK initialization error: " + status + "\n" + status.getDescription());
            }
        });
        BoldwinSDK.setShareGeoLocation(true);
    }

    private void initApplovinMax() {
        AppLovinSdk.getInstance(this).getSettings().setVerboseLogging(false);

        AppLovinSdkInitializationConfiguration initConfig = AppLovinSdkInitializationConfiguration
                .builder("1tLUnP4cVQqpHuHH2yMtfdESvvUhTB05NdbCoDTceDDNVnhd_T8kwIzXDN9iwbdULTboByF-TtNaiTmsoVbxZw", this)
                .setMediationProvider(AppLovinMediationProvider.MAX)
                .build();

        AppLovinSdk.getInstance(this).initialize(initConfig, result -> {
            Log.d("ApplovinInitialization", "Initialization result: " + result);
        });
    }

    private void initIronSource() {
        LevelPlayInitRequest initRequest = new LevelPlayInitRequest.Builder("246d499a5").build();
        LevelPlay.init(this, initRequest, new LevelPlayInitListener() {
            @Override
            public void onInitSuccess(LevelPlayConfiguration configuration) {
                Log.d(TAG, "IronSource initialized successfully.");
            }

            @Override
            public void onInitFailed(LevelPlayInitError error) {
                Log.e(TAG, "IronSource initialization failed: " + error);
            }
        });
    }
}