
/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.activities;

import android.graphics.Color;
import android.os.Bundle;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.appcompat.app.AppCompatActivity;
import androidx.databinding.DataBindingUtil;
import com.boldwin.sdk.demo.java.R;
import com.boldwin.sdk.demo.java.databinding.ActivityDemoBinding;
import com.boldwin.sdk.demo.java.utils.testcases.TestCase;
import com.boldwin.sdk.demo.java.utils.testcases.TestCaseRepository;

public abstract class BaseAdActivity extends AppCompatActivity {

    protected final String TAG = this.getClass().getSimpleName();

    /**
     * ViewGroup container for any ad view.
     */
    protected ViewGroup getAdWrapperView() {
        return binding.frameAdWrapper;
    }

    /**
     * Seconds for auto-refreshing any banner ad.
     */
    protected final int refreshTimeSeconds = 30;

    protected ActivityDemoBinding binding;
    private TestCase testCase = TestCaseRepository.getLastTestCase();

    private ReloadState reloadState = ReloadState.PRESS_TO_LOAD;

    public abstract void reloadAd();

    @CallSuper
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DataBindingUtil.setContentView(this, R.layout.activity_demo);
        binding.tvTestCaseName.setText(testCase.getTitle());
        binding.btnReloadAd.setOnClickListener(v -> onReloadButtonClick());
        changeState(ReloadState.PRESS_TO_LOAD);
    }

    private void onReloadButtonClick() {
        switch (reloadState) {
            case PRESS_TO_LOAD:
                reloadAd();
                break;
            case LOADING:
                break;
        }
    }

    protected void changeState(ReloadState state) {
        reloadState = state;
        switch (state) {
            case PRESS_TO_LOAD:
                binding.btnReloadAd.setText("RELOAD");
                binding.btnReloadAd.setTextColor(Color.BLUE);
                break;
            case LOADING:
                binding.btnReloadAd.setText("LOADING...");
                binding.btnReloadAd.setTextColor(Color.GRAY);
                break;
        }
    }

    public enum ReloadState {
        PRESS_TO_LOAD,
        LOADING
    }
}