package com.boldwin.sdk.demo.java.examples.applovin;

import android.os.Bundle;
import android.util.Log;
import android.view.ViewGroup;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.sdk.AppLovinSdkUtils;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;

public class AppLovinBanner300x250Activity extends BaseAdActivity {

    private static final String TAG = "BaseAdActivity";

    private static final String PLACEMENT_ID = "9094fb29ce8d920d";
    private static final int WIDTH = 300;
    private static final int HEIGHT = 250;

    private MaxAdView adView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adView != null) {
            adView.destroy();
            adView = null;
        }
    }

    private void createAd() {
        // 1. Create MaxAdView
        adView = new MaxAdView(PLACEMENT_ID, MaxAdFormat.MREC, this);

        // 2. Configure ad view
        adView.setListener(createListener());
        adView.setLayoutParams(new ViewGroup.LayoutParams(
                AppLovinSdkUtils.dpToPx(this, WIDTH),
                AppLovinSdkUtils.dpToPx(this, HEIGHT)
        ));

        // 3. Load ad
        adView.loadAd();

        // 4. Add to the UI
        getAdWrapperView().addView(adView);
    }


    private static MaxAdViewAdListener createListener() {
        return new MaxAdViewAdListener() {
            @Override
            public void onAdLoaded(MaxAd maxAd) {
                Log.d(TAG, "Ad loaded successfully");
            }

            @Override
            public void onAdExpanded(MaxAd maxAd) {
            }

            @Override
            public void onAdCollapsed(MaxAd maxAd) {
            }

            @Override
            public void onAdDisplayed(MaxAd maxAd) {
            }

            @Override
            public void onAdHidden(MaxAd maxAd) {
            }

            @Override
            public void onAdClicked(MaxAd maxAd) {
            }

            @Override
            public void onAdLoadFailed(String s, MaxError maxError) {
                Log.e(TAG, "Ad loading failed: " + (maxError != null ? maxError.getMessage() : "unknown"));
            }

            @Override
            public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
                Log.e(TAG, "Ad displaying failed: " + (maxError != null ? maxError.getMessage() : "unknown"));
            }
        };
    }
}