package com.boldwin.sdk.demo.java.examples.applovin;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;

public class AppLovinInterstitialActivity extends BaseAdActivity {

    private static final String TAG = "BaseAdActivity";
    private static final String AD_UNIT_ID = "9d78b7bdf10683da";

    private MaxInterstitialAd adUnit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adUnit != null) {
            adUnit.destroy();
            adUnit = null;
        }
    }

    private void createAd() {
        // 1. Create MaxInterstitialAd
        MaxInterstitialAd interstitial = new MaxInterstitialAd(AD_UNIT_ID);
        this.adUnit = interstitial;

        // 2. Configure listener
        MaxAdListener listener = createListener(interstitial, this);
        interstitial.setListener(listener);

        // 3. Load ad
        interstitial.loadAd();
    }

    private static MaxAdListener createListener(final MaxInterstitialAd ad, final Activity activity) {
        return new MaxAdListener() {
            @Override
            public void onAdLoaded(MaxAd maxAd) {
                Log.d(TAG, "Ad loaded successfully");
                // 4. Show ad
                ad.showAd(activity);
            }

            @Override
            public void onAdLoadFailed(String s, MaxError maxError) {
                Log.e(TAG, "Ad loading failed: " + (maxError != null ? maxError.getMessage() : "unknown"));
            }

            @Override
            public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
                Log.e(TAG, "Ad displaying failed: " + (maxError != null ? maxError.getMessage() : "unknown"));
            }

            @Override
            public void onAdDisplayed(MaxAd maxAd) {
            }

            @Override
            public void onAdHidden(MaxAd maxAd) {
            }

            @Override
            public void onAdClicked(MaxAd maxAd) {
            }
        };
    }
}