package com.boldwin.sdk.demo.java.examples.applovin;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;

public class AppLovinRewardedActivity extends BaseAdActivity {

    private static final String TAG = "BaseAdActivity";

    private static final String AD_UNIT_ID = "595b7d9d452c83c9";

    private MaxRewardedAd adUnit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adUnit != null) {
            adUnit.destroy();
            adUnit = null;
        }
    }

    private void createAd() {
        // 1. Create MaxRewardedAd
        MaxRewardedAd rewarded = MaxRewardedAd.getInstance(AD_UNIT_ID, this);
        this.adUnit = rewarded;

        // 2. Configure listener
        MaxRewardedAdListener listener = createListener(rewarded, this);
        rewarded.setListener(listener);

        // 3. Load ad
        rewarded.loadAd();
    }

    private static MaxRewardedAdListener createListener(final MaxRewardedAd ad, final Activity activity) {
        return new MaxRewardedAdListener() {
            @Override
            public void onAdLoaded(MaxAd maxAd) {
                Log.d(TAG, "Ad loaded successfully");
                // 4. Show ad
                ad.showAd(activity);
            }

            @Override
            public void onAdLoadFailed(String s, MaxError maxError) {
                Log.e(TAG, "Ad loading failed: " + (maxError != null ? maxError.getMessage() : "unknown"));
            }

            @Override
            public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
                Log.e(TAG, "Ad displaying failed: " + (maxError != null ? maxError.getMessage() : "unknown"));
            }

            @Override
            public void onAdDisplayed(MaxAd maxAd) {
            }

            @Override
            public void onAdHidden(MaxAd maxAd) {
            }

            @Override
            public void onAdClicked(MaxAd maxAd) {
            }

            @Override
            public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
                Log.d(TAG, "User rewarded: " + (maxReward != null ? maxReward.getLabel() + " " + maxReward.getAmount() : "unknown reward"));
            }

        };
    }
}