
/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.examples.inapp;

import android.os.Bundle;
import android.util.Log;
import com.boldwin.sdk.api.adunits.BoldwinAdView;
import com.boldwin.sdk.api.listeners.BoldwinAdViewListener;
import com.boldwin.sdk.api.listeners.BoldwinAdViewSizeListener;
import com.boldwin.sdk.api.utils.BoldwinAd;
import com.boldwin.sdk.api.utils.BoldwinAdSize;
import com.boldwin.sdk.api.utils.BoldwinError;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;

public class InAppDisplayBanner300x250Activity extends BaseAdActivity {

    public static final String PLACEMENT_ID = "686e42a0035b2ced064cc938";

    private BoldwinAdView adView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        createAd();
    }

    private void createAd() {
        getAdWrapperView().removeAllViews();

        // 1. Create BoldwinAdView
        adView = new BoldwinAdView(this);

        // 2. Configure ad view
        adView.setPlacementId(PLACEMENT_ID);
        adView.setAdSizes(BoldwinAdSize.BANNER_300x250);
        adView.setAdListener(createListener());
        adView.setSizeListener(createSizeListener());
        adView.setAutoRefreshPeriod(refreshTimeSeconds);

        // 3. Load ad
        adView.loadAd();

        // 4. Add to the UI
        getAdWrapperView().addView(adView);
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    private BoldwinAdViewListener createListener() {
        return new BoldwinAdViewListener() {
            @Override
            public void onAdLoaded(BoldwinAdView bannerView, BoldwinAd ad) {
                Log.d(TAG, "Ad loaded: " + ad);
            }

            @Override
            public void onAdDisplayed(BoldwinAdView bannerView) {
            }

            @Override
            public void onAdFailed(BoldwinAdView bannerView, BoldwinError error) {
                Log.e(TAG, "Ad failed to load: " + (error != null ? error.getMessage() : "Unknown error"));
            }

            @Override
            public void onAdClicked(BoldwinAdView bannerView) {
            }

            @Override
            public void onAdClosed(BoldwinAdView bannerView) {
            }
        };
    }

    private BoldwinAdViewSizeListener createSizeListener() {
        return (boldwinAdView, size) -> Log.d(TAG, "The ad size will change to size: " + size);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adView != null) {
            adView.destroy();
        }
    }
}