package com.boldwin.sdk.demo.java.examples.inapp;

import android.os.Bundle;
import android.util.Log;

import com.boldwin.sdk.api.BoldwinSDK;
import com.boldwin.sdk.api.adunits.BoldwinAdView;
import com.boldwin.sdk.api.listeners.BoldwinAdViewListener;
import com.boldwin.sdk.api.utils.BoldwinAd;
import com.boldwin.sdk.api.utils.BoldwinAdSize;
import com.boldwin.sdk.api.utils.BoldwinError;
import com.boldwin.sdk.api.utils.targeting.BoldwinTargeting;
import com.boldwin.sdk.api.utils.targeting.app.BoldwinContent;
import com.boldwin.sdk.api.utils.targeting.app.BoldwinContentProducer;
import com.boldwin.sdk.api.utils.targeting.app.BoldwinPublisher;
import com.boldwin.sdk.api.utils.targeting.app.BoldwinTargetingApp;
import com.boldwin.sdk.api.utils.targeting.common.BoldwinTargetingData;
import com.boldwin.sdk.api.utils.targeting.common.BoldwinTargetingExt;
import com.boldwin.sdk.api.utils.targeting.common.BoldwinTargetingSegment;
import com.boldwin.sdk.api.utils.targeting.user.BoldwinExtendedId;
import com.boldwin.sdk.api.utils.targeting.user.BoldwinGeo;
import com.boldwin.sdk.api.utils.targeting.user.BoldwinTargetingUser;
import com.boldwin.sdk.api.utils.targeting.user.BoldwinUniqueId;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InAppDisplayBannerWithTargetingActivity extends BaseAdActivity {

    public static final String PLACEMENT_ID = "686e42a0035b2ced064cc938";

    private BoldwinAdView adView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setTargeting();
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adView != null) {
            adView.destroy();
            adView = null;
        }
        BoldwinSDK.setTargeting(null);
    }

    private void createAd() {
        getAdWrapperView().removeAllViews();

        // 1. Create BoldwinAdView
        BoldwinAdView adView = new BoldwinAdView(this);
        this.adView = adView;

        // 2. Configure ad view
        adView.setPlacementId(PLACEMENT_ID);
        adView.setAdSizes(BoldwinAdSize.BANNER_300x250);
        adView.setAdListener(createListener());
        adView.setSizeListener((view, size) -> {
            Log.d(TAG, "The ad size will change to size: " + size);
        });
        adView.setAutoRefreshPeriod(refreshTimeSeconds);

        // 3. Load ad
        adView.loadAd();

        // 4. Add to the UI
        getAdWrapperView().addView(adView);
    }

    private void setTargeting() {
        BoldwinTargeting targeting = new BoldwinTargeting.Builder()
                .app(createApp())
                .user(createUser())
                .build();

        BoldwinSDK.setTargeting(targeting);
    }

    private BoldwinContent createContent() {
        BoldwinTargetingExt segmentExt = new BoldwinTargetingExt();
        segmentExt.put("ext_key", "Test value for BoldwinTargetingSegment");
        BoldwinTargetingSegment segment = new BoldwinTargetingSegment.Builder()
                .id("segment_001")
                .name("Test Segment")
                .value("test_value")
                .ext(segmentExt)
                .build();

        BoldwinTargetingExt dataExt = new BoldwinTargetingExt();
        dataExt.put("ext_key", "Test value for BoldwinTargetingData");
        BoldwinTargetingData targetingData = new BoldwinTargetingData.Builder()
                .id("data_001")
                .name("Test Data")
                .segment(Arrays.asList(segment))
                .ext(dataExt)
                .build();

        BoldwinTargetingExt producerExt = new BoldwinTargetingExt();
        producerExt.put("ext_key", "Test value for BoldwinContentProducer");
        BoldwinContentProducer producer = new BoldwinContentProducer.Builder()
                .id("producer_001")
                .name("Test Producer")
                .cat(Arrays.asList("Category1", "Category2"))
                .domain("producer.com")
                .ext(producerExt)
                .build();

        BoldwinTargetingExt contentExt = new BoldwinTargetingExt();
        contentExt.put("ext_key", "Test value for BoldwinContent");
        return new BoldwinContent.Builder()
                .id("content_001")
                .title("Test Content")
                .series("Test Series")
                .season("Season 1")
                .episode(1)
                .artist("Test Artist")
                .genre("Test Genre")
                .album("Test Album")
                .isrc("TEST123456789")
                .producer(producer)
                .url("https://test.com/content")
                .productionQuality(1)
                .context(2)
                .contentRating("PG-13")
                .userRating("4.5")
                .qagMediaRating(1)
                .keywords("test,content,sample")
                .liveStream(0)
                .sourceRelationship(1)
                .len(3600)
                .language("en")
                .embeddable(1)
                .categories(Arrays.asList("Category1", "Category2", "Category3"))
                .data(Arrays.asList(targetingData))
                .ext(contentExt)
                .build();
    }

    private BoldwinTargetingApp createApp() {
        BoldwinContent content = createContent();

        BoldwinTargetingExt publisherExt = new BoldwinTargetingExt();
        publisherExt.put("ext_key", "Test value for BoldwinPublisher");
        BoldwinPublisher publisher = new BoldwinPublisher.Builder()
                .id("pub_001")
                .name("Test Publisher")
                .domain("test.com")
                .categories(new ArrayList<>(Arrays.asList("News", "Entertainment")))
                .ext(publisherExt)
                .build();

        BoldwinTargetingExt appExt = new BoldwinTargetingExt();
        appExt.put("ext_key", "Test value for BoldwinTargetingApp");
        return new BoldwinTargetingApp.Builder()
                .bundle(getPackageName())
                .version("1.0.0")
                .name("Test App")
                .storeUrl("https://play.google.com/store/apps/test")
                .domain("app.test.com")
                .paid(1)
                .privacyPolicy(1)
                .keywords("app,test,demo")
                .cat(Arrays.asList("IAB1", "IAB2", "IAB3"))
                .sectionCat(Arrays.asList("Section1", "Section2"))
                .pageCat(Arrays.asList("Page1", "Page2"))
                .publisher(publisher)
                .content(content)
                .ext(appExt)
                .build();
    }

    private BoldwinTargetingUser createUser() {
        List<BoldwinUniqueId> uniqueIds1 = Arrays.asList(
                new BoldwinUniqueId.Builder()
                        .id("unique_id_123")
                        .atype(1)
                        .build(),
                new BoldwinUniqueId.Builder()
                        .id("device_id_456")
                        .atype(2)
                        .build()
        );

        BoldwinExtendedId extendedId = new BoldwinExtendedId.Builder()
                .source("adserver.org")
                .uniqueIds(uniqueIds1)
                .build();

        BoldwinTargetingExt segmentExt = new BoldwinTargetingExt();
        segmentExt.put("ext_key", "Test value for BoldwinTargetingSegment (user)");
        BoldwinTargetingSegment segment = new BoldwinTargetingSegment.Builder()
                .id("segment_001")
                .name("Test Segment")
                .value("test_value")
                .ext(segmentExt)
                .build();

        BoldwinTargetingExt geoExt = new BoldwinTargetingExt();
        geoExt.put("ext_key", "Test value for BoldwinGeo");
        BoldwinGeo geo = new BoldwinGeo.Builder()
                .lat(55.7558)
                .lon(37.6173)
                .type(1)
                .accuracy(30)
                .lastfix(300)
                .ipservice(3)
                .country("UKR")
                .region("KYI")
                .regionfips104("RS45")
                .metro("0001")
                .city("Kyiv")
                .zip("101000")
                .utcoffset(180)
                .ext(geoExt)
                .build();

        BoldwinTargetingExt dataExt = new BoldwinTargetingExt();
        dataExt.put("ext_key", "Test value for BoldwinTargetingData (user)");
        BoldwinTargetingData userData = new BoldwinTargetingData.Builder()
                .id("user_001")
                .name("Test User")
                .segment(new ArrayList<>(Arrays.asList(segment)))
                .ext(dataExt)
                .build();

        BoldwinTargetingExt userExt = new BoldwinTargetingExt();
        userExt.put("ext_key", "Test value for BoldwinTargetingUser");
        return new BoldwinTargetingUser.Builder()
                .id("user123")
                .buyerUid("buyer456")
                .yearOfBirth(1990)
                .gender("M")
                .keywords("user_keyword1,user_keyword2")
                .geo(geo)
                .data(new ArrayList<>(Arrays.asList(userData)))
                .extendedIds(new ArrayList<>(Arrays.asList(extendedId)))
                .customData("customUserData123")
                .ext(userExt)
                .build();
    }

    private BoldwinAdViewListener createListener() {
        return new BoldwinAdViewListener() {
            @Override
            public void onAdLoaded(BoldwinAdView bannerView, BoldwinAd ad) {
                Log.d(TAG, "Ad loaded: " + ad);
            }

            @Override
            public void onAdDisplayed(BoldwinAdView bannerView) {
            }

            @Override
            public void onAdFailed(BoldwinAdView bannerView, BoldwinError error) {
                Log.e(TAG, "Ad failed to load: " + (error != null ? error.getMessage() : "unknown"));
            }

            @Override
            public void onAdClicked(BoldwinAdView bannerView) {
            }

            @Override
            public void onAdClosed(BoldwinAdView bannerView) {
            }
        };
    }

    @Override
    public void reloadAd() {
        createAd();
    }
}