package com.boldwin.sdk.demo.java.examples.inapp;

import android.os.Bundle;
import android.util.Log;
import com.boldwin.sdk.api.adunits.BoldwinInterstitial;
import com.boldwin.sdk.api.listeners.BoldwinInterstitialListener;
import com.boldwin.sdk.api.utils.BoldwinAd;
import com.boldwin.sdk.api.utils.BoldwinError;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;
import org.jetbrains.annotations.NotNull;

public class InAppDisplayInterstitialActivity extends BaseAdActivity {

    public static final String PLACEMENT_ID = "686e42a0035b2ced064cc938";

    private BoldwinInterstitial interstitial;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    private void createAd() {
        // 1. Create BoldwinInterstitial
        interstitial = new BoldwinInterstitial(PLACEMENT_ID, this);

        // 2. Configure listener
        interstitial.setAdListener(createListener());

        // 3. Load ad
        interstitial.loadAd();
    }

    private @NotNull BoldwinInterstitialListener createListener() {
        return new BoldwinInterstitialListener() {
            @Override
            public void onAdLoaded(BoldwinAd ad) {
                Log.d(TAG, "Ad loaded: " + ad);
                // 4. Show ad
                show();
            }

            @Override
            public void onAdFailed(BoldwinError error) {
                Log.e(TAG, "Ad failed to load: " + (error != null ? error.getMessage() : "unknown"));
            }

            @Override
            public void onAdOpened() {
            }

            @Override
            public void onAdClicked() {
            }

            @Override
            public void onAdClosed() {
            }
        };
    }

    private void show() {
        if (interstitial != null) {
            interstitial.showAd();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (interstitial != null) {
            interstitial.destroy();
            interstitial = null;
        }
    }
}