package com.boldwin.sdk.demo.java.examples.inapp;

import android.os.Bundle;
import android.util.Log;
import com.boldwin.sdk.api.adunits.BoldwinRewarded;
import com.boldwin.sdk.api.listeners.BoldwinRewardedListener;
import com.boldwin.sdk.api.utils.BoldwinAd;
import com.boldwin.sdk.api.utils.BoldwinAdSize;
import com.boldwin.sdk.api.utils.BoldwinError;
import com.boldwin.sdk.api.utils.BoldwinReward;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;
import org.jetbrains.annotations.NotNull;

public class InAppVideoRewardedActivity extends BaseAdActivity {

    public static final String PLACEMENT_ID = "686e42a0035b2ced064cc938";

    private BoldwinRewarded adUnit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    private void createAd() {
        // 1. Create BoldwinRewarded
        adUnit = new BoldwinRewarded(PLACEMENT_ID, this);

        // 2. Configure listener
        adUnit.setAdSizes(new BoldwinAdSize(320, 480));
        adUnit.setAdListener(createListener());

        // 3. Load ad
        adUnit.loadAd();
    }

    private @NotNull BoldwinRewardedListener createListener() {
        return new BoldwinRewardedListener() {
            @Override
            public void onAdLoaded(BoldwinAd ad) {
                Log.d(TAG, "Ad loaded: " + ad);
                // 4. Show ad
                show();
            }

            @Override
            public void onAdFailed(BoldwinError error) {
                Log.e(TAG, "Ad failed to load: " + (error != null ? error.getMessage() : "unknown"));
            }

            @Override
            public void onAdOpened() {
            }

            @Override
            public void onAdClicked() {
            }

            @Override
            public void onAdClosed() {
            }

            @Override
            public void onUserEarnedReward(BoldwinReward reward) {
                Log.d(TAG, "User earned reward: " + reward);
            }
        };
    }

    private void show() {
        if (adUnit != null) {
            adUnit.showAd();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adUnit != null) {
            adUnit.destroy();
            adUnit = null;
        }
    }
}