package com.boldwin.sdk.demo.java.examples.ironsource;

import android.os.Bundle;
import android.util.Log;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.LevelPlayAdSize;
import com.unity3d.mediation.banner.LevelPlayBannerAdView;
import com.unity3d.mediation.banner.LevelPlayBannerAdViewListener;

public class IronSourceBanner300x250Activity extends BaseAdActivity {

    private static final String TAG = "BaseAdActivity";

    private static final String PLACEMENT_ID = "ba3rytaxz7neec55";

    private LevelPlayBannerAdView adView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (adView != null) {
            adView.destroy();
            adView = null;
        }
    }

    private void createAd() {
        getAdWrapperView().removeAllViews();

        // 1. Create LevelPlayBannerAdView
        LevelPlayAdSize adSize = LevelPlayAdSize.MEDIUM_RECTANGLE;
        LevelPlayBannerAdView.Config adConfig = new LevelPlayBannerAdView.Config.Builder()
                .setAdSize(adSize)
                .setPlacementName("Banner 300x250")
                .build();

        LevelPlayBannerAdView view = new LevelPlayBannerAdView(this, PLACEMENT_ID, adConfig);
        this.adView = view;

        view.setBannerListener(createListener());

        // 2. Load ad
        view.loadAd();

        // 3. Add to the UI
        getAdWrapperView().addView(view);
    }

    private LevelPlayBannerAdViewListener createListener() {
        return new LevelPlayBannerAdViewListener() {
            @Override
            public void onAdLoaded(LevelPlayAdInfo adInfo) {
                Log.d(TAG, "Ad loaded successfully");
            }

            @Override
            public void onAdLoadFailed(LevelPlayAdError error) {
                Log.e(TAG, "Ad loading failed: " + error);
            }

            @Override
            public void onAdDisplayed(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdDisplayFailed(LevelPlayAdInfo adInfo, LevelPlayAdError error) {
            }

            @Override
            public void onAdExpanded(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdClicked(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdCollapsed(LevelPlayAdInfo adInfo) {
            }
        };
    }
}