package com.boldwin.sdk.demo.java.examples.ironsource;

import android.os.Bundle;
import android.util.Log;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.interstitial.LevelPlayInterstitialAd;
import com.unity3d.mediation.interstitial.LevelPlayInterstitialAdListener;

public class IronSourceInterstitialActivity extends BaseAdActivity {

    private static final String TAG = "BaseAdActivity";

    private static final String PLACEMENT_ID = "ipv4mgx9t2uy2bgb";

    private LevelPlayInterstitialAd adUnit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    private void createAd() {
        // 1. Create LevelPlayInterstitialAd
        LevelPlayInterstitialAd interstitial = new LevelPlayInterstitialAd(PLACEMENT_ID);
        this.adUnit = interstitial;

        // 2. Configure listener
        interstitial.setListener(createListener());

        // 3. Load ad
        interstitial.loadAd();
    }

    private void showAd() {
        if (adUnit != null && adUnit.isAdReady()) {
            adUnit.showAd(this, "Main interstitial");
        }
    }

    private LevelPlayInterstitialAdListener createListener() {
        return new LevelPlayInterstitialAdListener() {
            @Override
            public void onAdLoaded(LevelPlayAdInfo adInfo) {
                Log.d(TAG, "Ad loaded successfully");
                // 4. Show ad
                showAd();
            }

            @Override
            public void onAdLoadFailed(LevelPlayAdError error) {
                Log.e(TAG, "Ad loading failed: " + error);
            }

            @Override
            public void onAdDisplayed(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdDisplayFailed(LevelPlayAdError error, LevelPlayAdInfo adInfo) {
                changeState(ReloadState.PRESS_TO_LOAD);
            }

            @Override
            public void onAdClosed(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdClicked(LevelPlayAdInfo adInfo) {
            }
        };
    }
}