package com.boldwin.sdk.demo.java.examples.ironsource;

import android.os.Bundle;
import android.util.Log;
import com.boldwin.sdk.demo.java.activities.BaseAdActivity;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.rewarded.LevelPlayReward;
import com.unity3d.mediation.rewarded.LevelPlayRewardedAd;
import com.unity3d.mediation.rewarded.LevelPlayRewardedAdListener;

public class IronSourceRewardedActivity extends BaseAdActivity {

    private static final String TAG = "BaseAdActivity";

    private static final String PLACEMENT_ID = "5smg1vb2ynklgjjo";

    private LevelPlayRewardedAd adUnit;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        createAd();
    }

    @Override
    public void reloadAd() {
        createAd();
    }

    private void createAd() {
        // 1. Create LevelPlayRewardedAd
        LevelPlayRewardedAd rewarded = new LevelPlayRewardedAd(PLACEMENT_ID);
        this.adUnit = rewarded;

        // 2. Configure listener
        rewarded.setListener(createListener());

        // 3. Load ad
        rewarded.loadAd();
    }

    private void showAd() {
        if (adUnit != null) {
            adUnit.showAd(this, "Main rewarded");
        }
    }

    private LevelPlayRewardedAdListener createListener() {
        return new LevelPlayRewardedAdListener() {
            @Override
            public void onAdLoaded(LevelPlayAdInfo adInfo) {
                Log.d(TAG, "Ad loaded successfully");
                // 4. Show ad
                showAd();
            }

            @Override
            public void onAdLoadFailed(LevelPlayAdError error) {
                Log.e(TAG, "Ad loading failed: " + error);
            }

            @Override
            public void onAdDisplayed(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdDisplayFailed(LevelPlayAdError error, LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdClosed(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdClicked(LevelPlayAdInfo adInfo) {
            }

            @Override
            public void onAdRewarded(LevelPlayReward reward, LevelPlayAdInfo adInfo) {
            }
        };
    }

}