/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.utils;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.preference.PreferenceManager;

public class Settings {

    private static final String KEY_REFRESH_TIME = "KEY_REFRESH_TIME";
    private static final String KEY_LAST_INTEGRATION_KIND = "KEY_LAST_INTEGRATION_KIND";
    private static final String KEY_LAST_AD_FORMAT = "KEY_LAST_AD_FORMAT";

    private static Settings INSTANCE = null;
    private final SharedPreferences preferences;

    private Settings(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    public static void init(Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(context);
        INSTANCE = new Settings(preferences);
        INSTANCE.setFakeGdpr();
    }

    public static Settings get() {
        if (INSTANCE == null) {
            throw new NullPointerException();
        }
        return INSTANCE;
    }

    public int getLastIntegrationKindId() {
        return preferences.getInt(KEY_LAST_INTEGRATION_KIND, 1);
    }

    public void setLastIntegrationKindId(int value) {
        preferences.edit().putInt(KEY_LAST_INTEGRATION_KIND, value).apply();
    }

    public int getLastAdFormatId() {
        return preferences.getInt(KEY_LAST_AD_FORMAT, 0);
    }

    public void setLastAdFormatId(int value) {
        preferences.edit().putInt(KEY_LAST_AD_FORMAT, value).apply();
    }

    /**
     * Only for test cases!
     */
    private void setFakeGdpr() {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt("IABTCF_gdprApplies", 0);
        editor.putInt("IABTCF_CmpSdkID", 123);
        editor.apply();
    }
}