/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.utils.testcases;

/**
 * Enum representing different ad formats with their descriptions.
 */
public enum AdFormat {
    /**
     * Banner ad format.
     */
    BANNER("Banner"),

    /**
     * Interstitial ad format.
     */
    INTERSTITIAL("Interstitial"),

    /**
     * Rewarded ad format.
     */
    REWARDED("Rewarded");

    private final String description;

    /**
     * Constructor for AdFormat enum.
     *
     * @param description The description of the ad format.
     */
    AdFormat(String description) {
        this.description = description;
    }

    /**
     * Gets the description of the ad format.
     *
     * @return The description of the ad format.
     */
    public String getDescription() {
        return description;
    }
}