/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.utils.testcases;

/**
 * Enum representing different integration kinds for ad servers.
 */
public enum IntegrationKind {
    /**
     * In-App integration with no ad server.
     */
    NO_AD_SERVER("In-App (No Ad Server)"),

    /**
     * AppLovin MAX integration.
     */
    MAX("AppLovin MAX"),

    /**
     * IronSource integration.
     */
    IRON_SOURCE("IronSource");

    private final String adServer;

    /**
     * Constructor for IntegrationKind enum.
     *
     * @param adServer The name of the ad server associated with this integration kind
     */
    IntegrationKind(String adServer) {
        this.adServer = adServer;
    }

    /**
     * Gets the ad server name associated with this integration kind.
     *
     * @return The ad server name
     */
    public String getAdServer() {
        return adServer;
    }
}