/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.utils.testcases;

import android.app.Activity;

public class TestCase {
    private final String title;
    private final AdFormat adFormat;
    private final IntegrationKind integrationKind;
    private final Class<? extends Activity> activity;

    public TestCase(String title, AdFormat adFormat, IntegrationKind integrationKind, Class<? extends Activity> activity) {
        this.title = title;
        this.adFormat = adFormat;
        this.integrationKind = integrationKind;
        this.activity = activity;
    }

    public String getTitle() {
        return title;
    }

    public AdFormat getAdFormat() {
        return adFormat;
    }

    public IntegrationKind getIntegrationKind() {
        return integrationKind;
    }

    public Class<? extends Activity> getActivity() {
        return activity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TestCase testCase = (TestCase) o;

        if (!title.equals(testCase.title)) return false;
        if (adFormat != testCase.adFormat) return false;
        if (integrationKind != testCase.integrationKind) return false;
        return activity.equals(testCase.activity);
    }

    @Override
    public int hashCode() {
        int result = title.hashCode();
        result = 31 * result + adFormat.hashCode();
        result = 31 * result + integrationKind.hashCode();
        result = 31 * result + activity.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "TestCase{" +
                "title='" + title + '\'' +
                ", adFormat=" + adFormat +
                ", integrationKind=" + integrationKind +
                ", activity=" + activity +
                '}';
    }
}