
/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.utils.testcases;

import android.annotation.SuppressLint;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.boldwin.sdk.demo.java.databinding.ListItemAdTypeBinding;

import java.util.ArrayList;
import java.util.List;

public class TestCaseAdapter extends RecyclerView.Adapter<TestCaseAdapter.AdTypeViewHolder> {

    private final OnItemClickedListener onItemClicked;
    private List<TestCase> list = new ArrayList<>();

    public TestCaseAdapter(OnItemClickedListener onItemClicked) {
        this.onItemClicked = onItemClicked;
    }

    @NonNull
    @Override
    public AdTypeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ListItemAdTypeBinding binding = ListItemAdTypeBinding.inflate(
                LayoutInflater.from(parent.getContext()),
                parent,
                false
        );

        AdTypeViewHolder viewHolder = new AdTypeViewHolder(binding);
        viewHolder.setOnItemClickedListener(onItemClicked);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull AdTypeViewHolder holder, int position) {
        holder.bind(list.get(position));
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    @SuppressLint("NotifyDataSetChanged")
    public void setList(List<TestCase> list) {
        this.list = list;
        notifyDataSetChanged();
    }

    public interface OnItemClickedListener {
        void onItemClicked(TestCase testCase);
    }

    public static class AdTypeViewHolder extends RecyclerView.ViewHolder {

        private final ListItemAdTypeBinding binding;
        private TestCase testCase;

        public AdTypeViewHolder(ListItemAdTypeBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        public void bind(TestCase testCase) {
            this.testCase = testCase;
            binding.tvName.setText(testCase.getTitle());
        }

        public void setOnItemClickedListener(final OnItemClickedListener onItemClicked) {
            binding.getRoot().setOnClickListener(v -> {
                if (testCase != null) {
                    onItemClicked.onItemClicked(testCase);
                }
            });
        }
    }
}