
/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.java.utils.testcases;

import com.boldwin.sdk.demo.java.examples.applovin.AppLovinBanner300x250Activity;
import com.boldwin.sdk.demo.java.examples.applovin.AppLovinBanner320x50Activity;
import com.boldwin.sdk.demo.java.examples.applovin.AppLovinInterstitialActivity;
import com.boldwin.sdk.demo.java.examples.applovin.AppLovinRewardedActivity;
import com.boldwin.sdk.demo.java.examples.inapp.InAppDisplayBanner300x250Activity;
import com.boldwin.sdk.demo.java.examples.inapp.InAppDisplayBannerWithTargetingActivity;
import com.boldwin.sdk.demo.java.examples.inapp.InAppDisplayInterstitialActivity;
import com.boldwin.sdk.demo.java.examples.inapp.InAppVideoRewardedActivity;
import com.boldwin.sdk.demo.java.examples.ironsource.IronSourceBanner300x250Activity;
import com.boldwin.sdk.demo.java.examples.ironsource.IronSourceBanner320x50Activity;
import com.boldwin.sdk.demo.java.examples.ironsource.IronSourceInterstitialActivity;
import com.boldwin.sdk.demo.java.examples.ironsource.IronSourceRewardedActivity;

import java.util.ArrayList;
import java.util.List;

public class TestCaseRepository {

    private static TestCase lastTestCase;

    public static List<TestCase> getList() {
        List<TestCase> testCases = new ArrayList<>();

        // In-App (no ad server)
        testCases.add(new TestCase(
                "In-App Banner 300x250",
                AdFormat.BANNER,
                IntegrationKind.NO_AD_SERVER,
                InAppDisplayBanner300x250Activity.class
        ));
        testCases.add(new TestCase(
                "In-App Banner 300x250 With Targeting",
                AdFormat.BANNER,
                IntegrationKind.NO_AD_SERVER,
                InAppDisplayBannerWithTargetingActivity.class
        ));
        testCases.add(new TestCase(
                "In-App Interstitial",
                AdFormat.INTERSTITIAL,
                IntegrationKind.NO_AD_SERVER,
                InAppDisplayInterstitialActivity.class
        ));
        testCases.add(new TestCase(
                "In-App Rewarded",
                AdFormat.REWARDED,
                IntegrationKind.NO_AD_SERVER,
                InAppVideoRewardedActivity.class
        ));

        // AppLovin
        testCases.add(new TestCase(
                "Applovin MAX Banner 320x50",
                AdFormat.BANNER,
                IntegrationKind.MAX,
                AppLovinBanner320x50Activity.class
        ));
        testCases.add(new TestCase(
                "Applovin MAX Banner 300x250",
                AdFormat.BANNER,
                IntegrationKind.MAX,
                AppLovinBanner300x250Activity.class
        ));
        testCases.add(new TestCase(
                "Applovin MAX Interstitial",
                AdFormat.INTERSTITIAL,
                IntegrationKind.MAX,
                AppLovinInterstitialActivity.class
        ));
        testCases.add(new TestCase(
                "Applovin MAX Rewarded",
                AdFormat.INTERSTITIAL,
                IntegrationKind.MAX,
                AppLovinRewardedActivity.class
        ));

        // IronSource
        testCases.add(new TestCase(
                "IronSource Banner 320x50",
                AdFormat.BANNER,
                IntegrationKind.IRON_SOURCE,
                IronSourceBanner320x50Activity.class
        ));
        testCases.add(new TestCase(
                "IronSource Banner 300x250",
                AdFormat.BANNER,
                IntegrationKind.IRON_SOURCE,
                IronSourceBanner300x250Activity.class
        ));
        testCases.add(new TestCase(
                "IronSource Interstitial",
                AdFormat.INTERSTITIAL,
                IntegrationKind.IRON_SOURCE,
                IronSourceInterstitialActivity.class
        ));
        testCases.add(new TestCase(
                "IronSource Rewarded",
                AdFormat.INTERSTITIAL,
                IntegrationKind.IRON_SOURCE,
                IronSourceRewardedActivity.class
        ));

        return testCases;
    }

    public static TestCase getLastTestCase() {
        return lastTestCase;
    }

    public static void setLastTestCase(TestCase testCase) {
        lastTestCase = testCase;
    }
}