/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin

import android.app.Application
import android.util.Log
import com.applovin.sdk.AppLovinMediationProvider
import com.applovin.sdk.AppLovinSdk
import com.applovin.sdk.AppLovinSdkInitializationConfiguration
import com.boldwin.sdk.api.BoldwinSDK
import com.boldwin.sdk.api.utils.BoldwinInitializationStatus
import com.boldwin.sdk.api.utils.BoldwinLogLevel
import com.boldwin.sdk.demo.kotlin.utils.Settings
import com.unity3d.mediation.*

class CustomApplication : Application() {

    companion object {
        private const val TAG = "BoldwinCustomApplication"
    }

    override fun onCreate() {
        super.onCreate()
        initBoldwinSDK()
        initApplovinMax()
        initIronSource()
        Settings.init(this)
    }

    private fun initBoldwinSDK() {
        val publisherId = "2016"
        BoldwinSDK.setLogLevel(BoldwinLogLevel.DEBUG)

        BoldwinSDK.initialize(publisherId, applicationContext) { status ->
            if (status == BoldwinInitializationStatus.SUCCEEDED) {
                Log.d(TAG, "SDK initialized successfully!")
            } else {
                Log.e(TAG, "SDK initialization error: $status\n${status.description}")
            }
        }
        BoldwinSDK.setShareGeoLocation(true)
//        BoldwinSDK.setSubjectToGdpr(true)
//        BoldwinSDK.setSubjectToCoppa(false)
//        BoldwinSDK.setGdprConsentString(consentString)
//        BoldwinSDK.setGdprPurposeConsent(purposeConsent)
    }

    private fun initApplovinMax() {
        AppLovinSdk.getInstance(this).settings.setVerboseLogging(false)

        val initConfig = AppLovinSdkInitializationConfiguration
            .builder(
                "1tLUnP4cVQqpHuHH2yMtfdESvvUhTB05NdbCoDTceDDNVnhd_T8kwIzXDN9iwbdULTboByF-TtNaiTmsoVbxZw",
                this
            )
            .setMediationProvider(AppLovinMediationProvider.MAX)
            .build()

        AppLovinSdk.getInstance(this).initialize(initConfig) {
            Log.d("ApplovinInitialization", "Initialization result: $it")
        }
    }

    private fun initIronSource() {
        val initRequest = LevelPlayInitRequest.Builder("246d499a5")
            .build()
        LevelPlay.init(this, initRequest, object : LevelPlayInitListener {
            override fun onInitSuccess(configuration: LevelPlayConfiguration) {
                Log.d(TAG, "IronSource initialized successfully.")
            }

            override fun onInitFailed(error: LevelPlayInitError) {
                Log.e(TAG, "IronSource initialization failed: $error")
            }
        })
    }

}
