/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.activities

import android.graphics.Color
import android.os.Bundle
import android.view.ViewGroup
import androidx.annotation.CallSuper
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import com.boldwin.sdk.demo.kotlin.utils.testcases.TestCase
import com.boldwin.sdk.demo.kotlin.utils.testcases.TestCaseRepository
import com.boldwin.sdk.demo.kotlin.utils.Settings
import com.boldwin.sdk.demo.kotlin.R
import com.boldwin.sdk.demo.kotlin.databinding.ActivityDemoBinding
import com.ironsource.sdk.IronSourceNetwork.showAd

abstract class BaseAdActivity : AppCompatActivity() {

    protected val TAG = this::class.java.simpleName

    /**
     * ViewGroup container for any ad view.
     */
    protected val adWrapperView: ViewGroup
        get() = binding.frameAdWrapper

    /**
     * Seconds for auto-refreshing any banner ad.
     */
    protected val refreshTimeSeconds = 30

    protected lateinit var binding: ActivityDemoBinding
    private var testCase: TestCase = TestCaseRepository.lastTestCase

    private var reloadState: ReloadState = ReloadState.PRESS_TO_LOAD

    abstract var reloadAd: () -> Unit

    @CallSuper
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_demo)
        binding.tvTestCaseName.text = testCase.title
        binding.btnReloadAd.setOnClickListener {
            onReloadButtonClick()
        }
        changeState(ReloadState.PRESS_TO_LOAD)
    }


    private fun onReloadButtonClick() {
        when (reloadState) {
            ReloadState.PRESS_TO_LOAD -> {
                reloadAd()
            }

            ReloadState.LOADING -> {}
        }
    }

    protected fun changeState(state: ReloadState) {
        reloadState = state
        when (state) {
            ReloadState.PRESS_TO_LOAD -> {
                binding.btnReloadAd.text = "RELOAD"
                binding.btnReloadAd.setTextColor(Color.BLUE)
            }

            ReloadState.LOADING -> {
                binding.btnReloadAd.text = "LOADING..."
                binding.btnReloadAd.setTextColor(Color.GRAY)
            }
        }
    }

    enum class ReloadState {
        PRESS_TO_LOAD,
        LOADING,
    }

}