/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.applovin

import android.os.Bundle
import android.util.Log
import android.view.ViewGroup
import com.applovin.mediation.MaxAd
import com.applovin.mediation.MaxAdFormat
import com.applovin.mediation.MaxAdViewAdListener
import com.applovin.mediation.MaxError
import com.applovin.mediation.ads.MaxAdView
import com.applovin.sdk.AppLovinSdkUtils
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity

class AppLovinBanner320x50Activity : BaseAdActivity() {

    private var adView: MaxAdView? = null

    override var reloadAd = { createAd() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        adView?.destroy()
    }


    private fun createAd() {
        // 1. Create MaxAdView
        adView = MaxAdView(APP_LOVIN_PLACEMENT_ID, MaxAdFormat.BANNER).apply {

            // 2. Configure ad unit
            setListener(createListener())
            layoutParams = ViewGroup.LayoutParams(
                AppLovinSdkUtils.dpToPx(this@AppLovinBanner320x50Activity, WIDTH),
                AppLovinSdkUtils.dpToPx(this@AppLovinBanner320x50Activity, HEIGHT)
            )

            // 3. Load ad
            loadAd()
        }

        // 4. Add ad view to the app UI
        adWrapperView.addView(adView)
    }

    companion object {
        private const val APP_LOVIN_PLACEMENT_ID = "db61360a094e3fc5"
        private const val WIDTH = 320
        private const val HEIGHT = 50
        private const val TAG = "BaseAdActivity"

        private fun createListener(): MaxAdViewAdListener {
            return object : MaxAdViewAdListener {
                override fun onAdLoaded(maxAd: MaxAd) {
                    Log.d(TAG, "Ad loaded successfully")
                }

                override fun onAdExpanded(maxAd: MaxAd) {
                }

                override fun onAdCollapsed(maxAd: MaxAd) {
                }

                override fun onAdDisplayed(maxAd: MaxAd) {
                }

                override fun onAdHidden(maxAd: MaxAd) {
                }

                override fun onAdClicked(maxAd: MaxAd) {
                }

                override fun onAdLoadFailed(s: String, maxError: MaxError) {
                    Log.e(TAG, "Ad loading failed: " + maxError.message)
                }

                override fun onAdDisplayFailed(maxAd: MaxAd, maxError: MaxError) {
                    Log.e(TAG, "Ad displaying failed: " + maxError.message)
                }
            }
        }
    }
}
