/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.applovin

import android.app.Activity
import android.os.Bundle
import android.util.Log
import com.applovin.mediation.MaxAd
import com.applovin.mediation.MaxError
import com.applovin.mediation.MaxReward
import com.applovin.mediation.MaxRewardedAdListener
import com.applovin.mediation.ads.MaxRewardedAd
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity

class AppLovinRewardedActivity : BaseAdActivity() {

    private var adUnit: MaxRewardedAd? = null

    override var reloadAd = { createAd() }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        adUnit?.destroy()
    }


    private fun createAd() {
        // 1. Create MaxRewardedAd
        val adUnit = MaxRewardedAd.getInstance(AD_UNIT_ID).apply { adUnit = this }

        // 2. Configure ad unit
        val listener = createListener(adUnit, this)
        adUnit.setListener(listener)

        // 3. Load ad
        adUnit.loadAd()
    }

    companion object {
        private const val AD_UNIT_ID = "beea8d79ab7abd01"
        private const val TAG = "BaseAdActivity"

        private fun createListener(
            ad: MaxRewardedAd,
            activity: Activity,
        ): MaxRewardedAdListener {
            return object : MaxRewardedAdListener {
                override fun onAdLoaded(maxAd: MaxAd) {
                    Log.d(TAG, "Ad loaded successfully")

                    // 4. Show ad
                    ad.showAd(activity)
                }

                override fun onAdLoadFailed(s: String, maxError: MaxError) {
                    Log.e(TAG, "Ad loading failed: " + maxError.message)
                }

                override fun onAdDisplayFailed(maxAd: MaxAd, maxError: MaxError) {
                    Log.e(TAG, "Ad displaying failed: " + maxError.message)
                }

                override fun onAdDisplayed(maxAd: MaxAd) {
                }

                override fun onAdHidden(maxAd: MaxAd) {
                }

                override fun onAdClicked(maxAd: MaxAd) {
                }

                override fun onUserRewarded(maxAd: MaxAd, reward: MaxReward) {
                }
            }
        }
    }
}
