/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.inapp

import android.os.Bundle
import android.util.Log
import com.boldwin.sdk.api.adunits.BoldwinAdView
import com.boldwin.sdk.api.listeners.BoldwinAdViewListener
import com.boldwin.sdk.api.listeners.BoldwinAdViewSizeListener
import com.boldwin.sdk.api.utils.BoldwinAd
import com.boldwin.sdk.api.utils.BoldwinAdSize
import com.boldwin.sdk.api.utils.BoldwinError
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity

class InAppDisplayBanner300x250Activity : BaseAdActivity() {

    companion object {
        const val PLACEMENT_ID = "686e42a0035b2ced064cc938"
    }

    private var adView: BoldwinAdView? = null

    override var reloadAd = { createAd() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        createAd()
    }

    private fun createAd() {
        adWrapperView.removeAllViews()

        // 1. Create BoldwinAdView
        val adView = BoldwinAdView(this).apply { adView = this }

        // 2. Configure ad unit
        adView.setPlacementId(PLACEMENT_ID)
        adView.setAdSizes(BoldwinAdSize.BANNER_300x250)
        adView.setAdListener(createListener())
        adView.setSizeListener(createSizeListener())
        adView.setAutoRefreshPeriod(refreshTimeSeconds)

        // 3. Load ad
        adView.loadAd()

        // 4. Add ad view to the app UI
        adWrapperView.addView(adView)
    }

    private fun createListener(): BoldwinAdViewListener = object : BoldwinAdViewListener {
        override fun onAdLoaded(bannerView: BoldwinAdView?, ad: BoldwinAd?) {
            Log.d(TAG, "Ad loaded: $ad")
        }

        override fun onAdFailed(
            bannerView: BoldwinAdView?,
            error: BoldwinError?
        ) {
            Log.e(TAG, "Ad failed to load: ${error?.message}")
        }

        override fun onAdDisplayed(bannerView: BoldwinAdView?) {
            Log.d(TAG, "Ad displayed")
        }

        override fun onAdClicked(bannerView: BoldwinAdView?) {
            Log.d(TAG, "Ad clicked")
        }

        override fun onAdClosed(bannerView: BoldwinAdView?) {
            Log.d(TAG, "Ad closed")
        }
    }

    private fun createSizeListener(): BoldwinAdViewSizeListener {
        return BoldwinAdViewSizeListener { adView, size ->
            Log.d(TAG, "The ad size will change to size: $size")
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        adView?.destroy()
    }

}
