/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.inapp

import android.os.Bundle
import android.util.Log
import com.boldwin.sdk.api.adunits.BoldwinInterstitial
import com.boldwin.sdk.api.listeners.BoldwinInterstitialListener
import com.boldwin.sdk.api.utils.BoldwinAd
import com.boldwin.sdk.api.utils.BoldwinError
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity

class InAppDisplayInterstitialActivity : BaseAdActivity() {

    companion object {
        const val PLACEMENT_ID = "686e42a0035b2ced064cc938"
    }

    private var interstitial: BoldwinInterstitial? = null

    override var reloadAd = { createAd() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        createAd()
    }

    private fun createAd() {
        // 1. Create BoldwinInterstitial
        interstitial = BoldwinInterstitial(PLACEMENT_ID, this)

        // 2. Configure listener
        interstitial?.setAdListener(createListener())

        // 3. Load ad
        interstitial?.loadAd()
    }

    private fun createListener(): BoldwinInterstitialListener = object : BoldwinInterstitialListener {
        override fun onAdLoaded(ad: BoldwinAd?) {
            Log.d(TAG, "Ad loaded: $ad")
            // 4. Show ad
            show()
        }

        override fun onAdFailed(error: BoldwinError?) {
        }

        override fun onAdOpened() {
        }

        override fun onAdClicked() {
        }

        override fun onAdClosed() {
        }
    }

    private fun show() {
        interstitial?.showAd()
    }


    override fun onDestroy() {
        super.onDestroy()
        interstitial?.destroy()
    }

}
