/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.inapp

import android.os.Bundle
import android.util.Log
import com.boldwin.sdk.api.adunits.BoldwinRewarded
import com.boldwin.sdk.api.listeners.BoldwinRewardedListener
import com.boldwin.sdk.api.utils.BoldwinAd
import com.boldwin.sdk.api.utils.BoldwinAdSize
import com.boldwin.sdk.api.utils.BoldwinError
import com.boldwin.sdk.api.utils.BoldwinReward
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity

class InAppVideoRewardedActivity : BaseAdActivity() {

    companion object {
        const val PLACEMENT_ID = "686e42a0035b2ced064cc938"
    }

    private var adUnit: BoldwinRewarded? = null


    override var reloadAd = { createAd() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        createAd()
    }

    private fun createAd() {
        // 1. Create BoldwinRewarded
        adUnit = BoldwinRewarded(PLACEMENT_ID, this)

        // 2. Configure ad unit
        adUnit?.setAdSizes(BoldwinAdSize(320, 480))
        adUnit?.setAdListener(createListener())

        // 3. Load ad
        adUnit?.loadAd()
    }

    private fun createListener(): BoldwinRewardedListener = object : BoldwinRewardedListener {
        override fun onAdLoaded(ad: BoldwinAd?) {
            Log.d(TAG, "Ad loaded: $ad")
            // 4. Show ad
            show()
        }

        override fun onAdFailed(error: BoldwinError?) {
            Log.e(TAG, "Ad failed to load: ${error?.message}")
        }

        override fun onAdOpened() {
        }

        override fun onAdClicked() {
        }

        override fun onAdClosed() {
        }

        override fun onUserEarnedReward(reward: BoldwinReward?) {
            Log.d(TAG, "User earned reward: $reward")
        }
    }

    private fun show() {
        adUnit?.showAd()
    }


    override fun onDestroy() {
        super.onDestroy()
        adUnit?.destroy()
    }

}
