/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.ironsource

import android.os.Bundle
import android.util.Log
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity
import com.unity3d.mediation.LevelPlayAdError
import com.unity3d.mediation.LevelPlayAdInfo
import com.unity3d.mediation.LevelPlayAdSize
import com.unity3d.mediation.banner.LevelPlayBannerAdView
import com.unity3d.mediation.banner.LevelPlayBannerAdViewListener

class IronSourceBanner320x50Activity : BaseAdActivity() {

    private var adView: LevelPlayBannerAdView? = null

    override var reloadAd = { createAd() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    override fun onDestroy() {
        super.onDestroy()
        adView?.destroy()
    }


    private fun createAd() {
        adWrapperView.removeAllViews()

        // 1. Create LevelPlayBannerAdView
        val adSize = LevelPlayAdSize.BANNER
        val adConfig = LevelPlayBannerAdView.Config.Builder()
            .setAdSize(adSize)
            .setPlacementName("Banner 320x50")
            .build()

        val adView = LevelPlayBannerAdView(this, PLACEMENT_ID, adConfig).apply { adView = this }
        adView.setBannerListener(createListener())

        // 2. Load ad
        adView.loadAd()

        // 3. Add view to UI
        adWrapperView.addView(adView)
    }

    private fun createListener(): LevelPlayBannerAdViewListener = object : LevelPlayBannerAdViewListener {
        override fun onAdLoaded(adInfo: LevelPlayAdInfo) {
            Log.d(TAG, "Ad loaded successfully")
        }

        override fun onAdLoadFailed(error: LevelPlayAdError) {
            Log.e(TAG, "Ad loading failed: $error")
        }

        override fun onAdDisplayed(adInfo: LevelPlayAdInfo) {
        }

        override fun onAdDisplayFailed(adInfo: LevelPlayAdInfo, error: LevelPlayAdError) {
        }

        override fun onAdExpanded(adInfo: LevelPlayAdInfo) {
        }

        override fun onAdClicked(adInfo: LevelPlayAdInfo) {
        }

        override fun onAdCollapsed(adInfo: LevelPlayAdInfo) {
        }
    }

    companion object {
        private const val PLACEMENT_ID = "ba3rytaxz7neec55"
        private const val TAG = "BaseAdActivity"
    }
}
