/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.examples.ironsource

import android.os.Bundle
import android.util.Log
import com.boldwin.sdk.demo.kotlin.activities.BaseAdActivity
import com.unity3d.mediation.LevelPlayAdError
import com.unity3d.mediation.LevelPlayAdInfo
import com.unity3d.mediation.rewarded.LevelPlayReward
import com.unity3d.mediation.rewarded.LevelPlayRewardedAd
import com.unity3d.mediation.rewarded.LevelPlayRewardedAdListener

class IronSourceRewardedActivity : BaseAdActivity() {

    private var adUnit: LevelPlayRewardedAd? = null

    override var reloadAd = { createAd() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        createAd()
    }

    private fun createAd() {
        // 1. Create LevelPlayRewardedAd
        val adUnit = LevelPlayRewardedAd(PLACEMENT_ID).apply { adUnit = this }

        // 2. Configure ad unit
        adUnit.setListener(createListener())

        // 3. Load ad
        adUnit.loadAd()
    }

    private fun showAd() {
        adUnit?.showAd(this, "Main rewarded")
    }

    private fun createListener(): LevelPlayRewardedAdListener = object : LevelPlayRewardedAdListener {
        override fun onAdLoaded(adInfo: LevelPlayAdInfo) {
            Log.d(TAG, "Ad loaded successfully")
            // 4. Show ad
            showAd()
        }

        override fun onAdLoadFailed(error: LevelPlayAdError) {
            Log.e(TAG, "Ad loading failed: $error")
        }

        override fun onAdDisplayed(adInfo: LevelPlayAdInfo) {
        }

        override fun onAdDisplayFailed(error: LevelPlayAdError, adInfo: LevelPlayAdInfo) {
        }

        override fun onAdClosed(adInfo: LevelPlayAdInfo) {
        }

        override fun onAdClicked(adInfo: LevelPlayAdInfo) {
        }

        override fun onAdRewarded(reward: LevelPlayReward, adInfo: LevelPlayAdInfo) {
        }
    }

    companion object {
        private const val PLACEMENT_ID = "5smg1vb2ynklgjjo"
    }
}
