/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.utils

import android.content.Context
import android.content.SharedPreferences
import androidx.preference.PreferenceManager

class Settings private constructor(
    private val preferences: SharedPreferences
) {

    companion object {
        private const val KEY_REFRESH_TIME = "KEY_REFRESH_TIME"
        private const val KEY_LAST_INTEGRATION_KIND = "KEY_LAST_INTEGRATION_KIND"
        private const val KEY_LAST_AD_FORMAT = "KEY_LAST_AD_FORMAT"

        private var INSTANCE: Settings? = null

        fun init(context: Context) {
            val preferences = PreferenceManager.getDefaultSharedPreferences(context)
            INSTANCE = Settings(preferences).apply {
                setFakeGdpr()
            }
        }

        fun get(): Settings {
            return INSTANCE ?: throw NullPointerException()
        }
    }

    var lastIntegrationKindId: Int
        get() = preferences.getInt(KEY_LAST_INTEGRATION_KIND, 1)
        set(value) {
            preferences.edit().putInt(KEY_LAST_INTEGRATION_KIND, value).apply()
        }

    var lastAdFormatId: Int
        get() = preferences.getInt(KEY_LAST_AD_FORMAT, 0)
        set(value) {
            preferences.edit().putInt(KEY_LAST_AD_FORMAT, value).apply()
        }

    /**
     * Only for test cases!
     */
    private fun setFakeGdpr() {
        preferences.edit().apply {
            putInt("IABTCF_gdprApplies", 0)
            putInt("IABTCF_CmpSdkID", 123)
            apply()
        }
    }

}