/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.utils.testcases

import android.annotation.SuppressLint
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.boldwin.sdk.demo.kotlin.databinding.ListItemAdTypeBinding

class TestCaseAdapter(
    private val onItemClicked: (TestCase) -> Unit
) : RecyclerView.Adapter<TestCaseAdapter.AdTypeViewHolder>() {

    private var list: List<TestCase> = arrayListOf()

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): AdTypeViewHolder {
        val binding = ListItemAdTypeBinding.inflate(
            LayoutInflater.from(parent.context),
            parent,
            false
        )

        val viewHolder = AdTypeViewHolder(binding)
        viewHolder.setOnItemClickedListener(onItemClicked)
        return viewHolder
    }

    override fun onBindViewHolder(holder: AdTypeViewHolder, position: Int) {
        holder.bind(list[position])
    }

    override fun getItemCount() = list.size


    @SuppressLint("NotifyDataSetChanged")
    fun setList(list: List<TestCase>) {
        this.list = list
        notifyDataSetChanged()
    }


    class AdTypeViewHolder(
        private val binding: ListItemAdTypeBinding
    ) : RecyclerView.ViewHolder(binding.root) {

        private var testCase: TestCase? = null

        fun bind(testCase: TestCase) {
            this.testCase = testCase
            binding.tvName.text = testCase.title
        }

        fun setOnItemClickedListener(onItemClicked: (TestCase) -> Unit) {
            binding.root.setOnClickListener {
                onItemClicked(testCase ?: return@setOnClickListener)
            }
        }

    }

}