/*
 * © 2025 BOLDWIN LTD.  All rights reserved.
 * You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * Specific authorizations and restrictions shall be provided for in the License.
 */

package com.boldwin.sdk.demo.kotlin.utils.testcases

import com.boldwin.sdk.demo.kotlin.examples.applovin.AppLovinBanner300x250Activity
import com.boldwin.sdk.demo.kotlin.examples.applovin.AppLovinBanner320x50Activity
import com.boldwin.sdk.demo.kotlin.examples.applovin.AppLovinInterstitialActivity
import com.boldwin.sdk.demo.kotlin.examples.applovin.AppLovinRewardedActivity
import com.boldwin.sdk.demo.kotlin.examples.inapp.InAppDisplayBanner300x250Activity
import com.boldwin.sdk.demo.kotlin.examples.inapp.InAppDisplayBannerWithTargetingActivity
import com.boldwin.sdk.demo.kotlin.examples.inapp.InAppDisplayInterstitialActivity
import com.boldwin.sdk.demo.kotlin.examples.inapp.InAppVideoRewardedActivity
import com.boldwin.sdk.demo.kotlin.examples.ironsource.IronSourceBanner300x250Activity
import com.boldwin.sdk.demo.kotlin.examples.ironsource.IronSourceBanner320x50Activity
import com.boldwin.sdk.demo.kotlin.examples.ironsource.IronSourceInterstitialActivity
import com.boldwin.sdk.demo.kotlin.examples.ironsource.IronSourceRewardedActivity

object TestCaseRepository {

    lateinit var lastTestCase: TestCase

    fun getList() = arrayListOf(
        /* In-App (no ad server) */
        TestCase(
            "In-App Banner 300x250",
            AdFormat.BANNER,
            IntegrationKind.NO_AD_SERVER,
            InAppDisplayBanner300x250Activity::class.java,
        ),
        TestCase(
            "In-App Banner 300x250 With Targeting",
            AdFormat.BANNER,
            IntegrationKind.NO_AD_SERVER,
            InAppDisplayBannerWithTargetingActivity::class.java,
        ),
        TestCase(
            "In-App Interstitial",
            AdFormat.INTERSTITIAL,
            IntegrationKind.NO_AD_SERVER,
            InAppDisplayInterstitialActivity::class.java,
        ),
        TestCase(
            "In-App Rewarded",
            AdFormat.REWARDED,
            IntegrationKind.NO_AD_SERVER,
            InAppVideoRewardedActivity::class.java,
        ),

        /* AppLovin */
        TestCase(
            "Applovin MAX Banner 320x50",
            AdFormat.BANNER,
            IntegrationKind.MAX,
            AppLovinBanner320x50Activity::class.java,
        ),
        TestCase(
            "Applovin MAX Banner 300x250",
            AdFormat.BANNER,
            IntegrationKind.MAX,
            AppLovinBanner300x250Activity::class.java,
        ),
        TestCase(
            "Applovin MAX Interstitial",
            AdFormat.INTERSTITIAL,
            IntegrationKind.MAX,
            AppLovinInterstitialActivity::class.java,
        ),
        TestCase(
            "Applovin MAX Rewarded",
            AdFormat.INTERSTITIAL,
            IntegrationKind.MAX,
            AppLovinRewardedActivity::class.java,
        ),

        /* IronSource */
        TestCase(
            "IronSource Banner 320x50",
            AdFormat.BANNER,
            IntegrationKind.IRON_SOURCE,
            IronSourceBanner320x50Activity::class.java,
        ),
        TestCase(
            "IronSource Banner 300x250",
            AdFormat.BANNER,
            IntegrationKind.IRON_SOURCE,
            IronSourceBanner300x250Activity::class.java,
        ),
        TestCase(
            "IronSource Interstitial",
            AdFormat.INTERSTITIAL,
            IntegrationKind.IRON_SOURCE,
            IronSourceInterstitialActivity::class.java,
        ),
        TestCase(
            "IronSource Rewarded",
            AdFormat.INTERSTITIAL,
            IntegrationKind.IRON_SOURCE,
            IronSourceRewardedActivity::class.java,
        ),
    )

}