/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "AppDelegate.h"

@interface AppDelegate ()
@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    [self initBoldwin];
    [self initApplovinSDK];
    [self initIronSource];
    
    return YES;
}

// MARK: SDK Initialization

-(void)initBoldwin {
    // Init SDK with respective publisher ID
    [BoldwinSDK initializeWithPublisherID:@"2016"];
}

-(void)initApplovinSDK {
    ALSdkInitializationConfiguration * config = [ALSdkInitializationConfiguration configurationWithSdkKey:@"<YOUR_SDK_KEY>"];
    
    [ALSdk.shared initializeWithConfiguration:config completionHandler:nil];
    [ALSdk.shared.settings setVerboseLoggingEnabled:YES];
}

-(void)initIronSource {
    LPMInitRequestBuilder * builder = [[LPMInitRequestBuilder alloc] initWithAppKey:@"246e5ae05"];
    LPMInitRequest * request = [builder build];
    
    [LevelPlay initWithRequest:request
                    completion:^(LPMConfiguration * _Nullable config, NSError * _Nullable error) {
        NSLog(@"ironSource: init failed with error:%@", error.localizedDescription);
    }];
}

#pragma mark - UISceneSession lifecycle

- (UISceneConfiguration *)application:(UIApplication *)application configurationForConnectingSceneSession:(UISceneSession *)connectingSceneSession options:(UISceneConnectionOptions *)options {
    return [[UISceneConfiguration alloc] initWithName:@"Default Configuration" sessionRole:connectingSceneSession.role];
}

@end
