/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "BannerBaseViewController.h"

@interface BannerBaseViewController ()

@property (weak, nonatomic) IBOutlet NSLayoutConstraint *containerWidthConstraint;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *containerHeightConstraint;

@end

@implementation BannerBaseViewController

-(id)init {
    self = [super initWithNibName:@"BannerBaseViewController" bundle:nil];
    _adSize = CGSizeMake(300, 250);
    
    return self;
}

-(id)initWithAdSize:(CGSize)adSize {
    _adSize = adSize;
    return [self init];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.containerWidthConstraint.constant = self.adSize.width;
    self.containerHeightConstraint.constant = self.adSize.height;
    
    [self.reloadButton addTarget:self
                          action:@selector(reload)
                forControlEvents:UIControlEventTouchUpInside];
}

- (void)reload {
    [self.reloadButton setEnabled:NO];
}


@end
