/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import <UIKit/UIKit.h>
#import "AdFormat.h"
#import "IntegrationKind.h"

typedef UIViewController* _Nonnull (^ConfigurationClosure)(void);

NS_ASSUME_NONNULL_BEGIN

@interface TestCase : NSObject

@property (nonatomic) NSString *title;
@property (nonatomic) IntegrationKind integrationKind;
@property (nonatomic) NSArray<NSNumber *> *adFormats;
@property (nonatomic) ConfigurationClosure configurationClosure;

-(id)initWithTitle:(NSString *)title
   integrationKind:(IntegrationKind)integrationKind
         adFormats:(NSArray<NSNumber *> *)adFormats
configurationClosure:(ConfigurationClosure)configurationClosure;

@end

NS_ASSUME_NONNULL_END
