/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "AppLovinBannerAdViewController.h"

@interface AppLovinBannerAdViewController ()

@property (nonatomic) MAAdView * maAdView;

@end

@implementation AppLovinBannerAdViewController

- (NSString *)adUnitId {
    return @"<AD_UNIT_ID>";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    self.maAdView = [[MAAdView alloc] initWithAdUnitIdentifier:self.adUnitId adFormat:MAAdFormat.mrec];
    
    self.maAdView.delegate = self;
    self.maAdView.frame = CGRectMake(0, 0, 300, 250);
    
    [self.containerView addSubview:self.maAdView];
    
    [self.maAdView loadAd];
}

- (void)reload {
    [super reload];
    
    [self.maAdView removeFromSuperview];
    self.maAdView = nil;
    
    [self createAd];
}

# pragma mark - MAAdViewAdDelegate

- (void)didLoadAd:(MAAd *)ad {
    [self.reloadButton setEnabled:YES];
}

- (void)didFailToLoadAdForAdUnitIdentifier:(NSString *)adUnitIdentifier withError:(MAError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"AppLovin did fail to load ad with error: %@", error.message);
}

- (void)didFailToDisplayAd:(MAAd *)ad withError:(MAError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"AppLovin did fail to display ad with error: %@", error.message);
}

- (void)didExpandAd:(MAAd *)ad {}
- (void)didCollapseAd:(MAAd *)ad {}
- (void)didDisplayAd:(MAAd *)ad {}
- (void)didHideAd:(MAAd *)ad {}
- (void)didClickAd:(MAAd *)ad {}

@end
