/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "AppLovinMultiformatRewardedViewController.h"

@interface AppLovinMultiformatRewardedViewController ()

@property (nonatomic) MARewardedAd * rewardedAd;

@end

@implementation AppLovinMultiformatRewardedViewController

- (NSString *)adUnitId {
    return @"<AD_UNIT_ID>";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    self.rewardedAd = [MARewardedAd sharedWithAdUnitIdentifier:self.adUnitId];
    
    self.rewardedAd.delegate = self;
    
    [self.rewardedAd loadAd];
}

- (void)showAd {
    [super showAd];
    
    if (self.rewardedAd != nil && self.rewardedAd.isReady) {
        [self.rewardedAd showAd];
    }
}

- (void)reload {
    [self reload];
    
    self.rewardedAd = nil;
    
    [self createAd];
}

# pragma mark - MAAdDelegate

- (void)didLoadAd:(MAAd *)ad {
    [self.reloadButton setEnabled:YES];
    [self.showButton setEnabled:YES];
}

- (void)didFailToLoadAdForAdUnitIdentifier:(NSString *)adUnitIdentifier withError:(MAError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"AppLovin did fail to load ad with error: %@", error.message);
}

- (void)didFailToDisplayAd:(MAAd *)ad withError:(MAError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"Did fail to display ad with error: %@", error.message);
}

- (void)didRewardUserForAd:(MAAd *)ad withReward:(MAReward *)reward {
    NSLog(@"User did earn reward - label: %@, amount: %ld", reward.label, reward.amount);
}

- (void)didDisplayAd:(MAAd *)ad {}
- (void)didHideAd:(MAAd *)ad {}
- (void)didClickAd:(MAAd *)ad {}

@end
