/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "BoldwinBannerAdViewController.h"

@interface BoldwinBannerAdViewController ()

@property (nonatomic, strong, nullable) BoldwinAdView * boldwinAdView;

@end

@implementation BoldwinBannerAdViewController

- (NSString *)placementID {
    return @"686e42a0035b2ced064cc938";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    // 1. Create BoldwinAdView instance.
    CGSize adSize = CGSizeMake(300, 250);
    CGRect frame = CGRectMake(0, 0, adSize.width, adSize.height);

    BoldwinAdSize *boldwinAdSize = [[BoldwinAdSize alloc] initWithWidth:(NSInteger)adSize.width
                                                                 height:(NSInteger)adSize.height];

    BoldwinAdView *adView = [[BoldwinAdView alloc] initWithPlacementID:self.placementID
                                                                 frame:frame
                                                               adSizes:@[boldwinAdSize]];

    // 2. Optionally set delegates.
    adView.delegate = self;
    adView.adSizeDelegate = self;

    // 3. Configure BoldwinAdView.
    adView.autoRefreshPeriod = 15;

    // Store the instance.
    self.boldwinAdView = adView;

    // Add to UI.
    [self.containerView addSubview:adView];

    // 5. Load ad.
    [adView loadAd];
}

- (void)reload {
    [super reload];
    
    [self.boldwinAdView removeFromSuperview];
    self.boldwinAdView = nil;
    
    [self createAd];
}

#pragma mark - BoldwinAdViewSizeDelegate

- (void)adView:(BoldwinAdView *)adView willChangeAdSizeTo:(BoldwinAdSize *)size {
    // Called when ad view changes size.
    // Use to update the layout respectively.
}

#pragma mark - BoldwinAdViewDelegate

- (UIViewController *)adViewPresentationController {
    // Specify controller for modal presentation.
    return self;
}

- (void)adView:(BoldwinAdView *)adView didReceiveAd:(BoldwinAd *)didReceiveAd {
    // Called when ad is loaded.
    [self.reloadButton setEnabled:YES];
}

- (void)adView:(BoldwinAdView *)adView didFailToReceiveAdWith:(BoldwinError *)error {
    // Called when Boldwin SDK failed to load ad.
    NSLog(@"SDK did fail to receive ad with error: %@", error.localizedDescription);
    [self.reloadButton setEnabled:YES];
}

- (void)adViewWillPresentModal:(BoldwinAdView *)adView {
    // Called when modal is about to be presented.
}

- (void)adViewDidDismissModal:(BoldwinAdView *)adView {
    // Called when modal is dismissed.
}

- (void)adViewWillLeaveApplication:(BoldwinAdView *)adView {
    // Called when the application is about to enter the background
}

@end
