/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "BoldwinMultiformatInterstitialController.h"

@interface BoldwinMultiformatInterstitialController ()

@property (nonatomic, strong, nullable) BoldwinInterstitial * boldwinInterstitial;

@end

@implementation BoldwinMultiformatInterstitialController

- (NSString *)placementID {
    return @"686e42a0035b2ced064cc938";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    // 1. Create BoldwinInterstitial instance.
    BoldwinInterstitial *interstitial = [[BoldwinInterstitial alloc] initWithPlacementID:self.placementID];
    
    // 2. Optionally set delegates.
    interstitial.delegate = self;
    
    // Store instance.
    self.boldwinInterstitial = interstitial;
    
    // 3. Load ad.
    [interstitial loadAd];
}

- (void)showAd {
    [super showAd];
    
    // 4. Check if ad is ready to be displayed.
    if (self.boldwinInterstitial.isReady == YES) {
        
        // 5. Show the ad.
        [self.boldwinInterstitial showFrom:self];
    }
}

- (void)reload {
    [super reload];
    
    self.boldwinInterstitial = nil;
    [self createAd];
}

#pragma mark - BoldwinInterstitialDelegate

- (void)interstitialDidReceiveAd:(BoldwinInterstitial *)interstitial ad:(BoldwinAd *)ad {
    // Called when ad is loaded.
    [self.showButton setEnabled:YES];
    [self.reloadButton setEnabled:YES];
}

- (void)interstitial:(BoldwinInterstitial *)interstitial didFailToReceiveAdWithError:(BoldwinError *)error {
    // Called when Boldwin SDK failed to load ad.
    NSLog(@"SDK did fail to receive ad with error: %@", error.localizedDescription);
    [self.reloadButton setEnabled:YES];
}

- (void)interstitialWillPresentAd:(BoldwinInterstitial *)interstitial {
    // Called when interstitial is about to be presented.
}

- (void)interstitialDidDismissAd:(BoldwinInterstitial *)interstitial {
    // Called when interstitial is dismissed.
}

- (void)interstitialDidClickAd:(BoldwinInterstitial *)interstitial {
    // Called when interstitial was clicked.
}

- (void)interstitialWillLeaveApplication:(BoldwinInterstitial *)interstitial {
    // Called when the application is about to enter the background.
}

@end
