/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "BoldwinMultiformatRewardedController.h"

@interface BoldwinMultiformatRewardedController ()

@property (nonatomic, strong, nullable) BoldwinRewarded * boldwinRewarded;

@end

@implementation BoldwinMultiformatRewardedController

- (NSString *)placementID {
    return @"686e42a0035b2ced064cc938";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    // 1. Create BoldwinRewarded instance.
    BoldwinRewarded *rewarded = [[BoldwinRewarded alloc] initWithPlacementID:self.placementID];
    
    // 2. Optionally set delegates.
    rewarded.delegate = self;
    
    // Store instance.
    self.boldwinRewarded = rewarded;
    
    // 3. Load ad.
    [rewarded loadAd];
}

- (void)showAd {
    [super showAd];
    
    // 4. Check if ad is ready to be displayed.
    if (self.boldwinRewarded.isReady == YES) {
        
        // 5. Show the ad.
        [self.boldwinRewarded showFrom:self];
    }
}

- (void)reload {
    [super reload];
    
    self.boldwinRewarded = nil;
    [self createAd];
}

#pragma mark - BoldwinRewardedDelegate

- (void)rewardedAdDidReceiveAd:(BoldwinRewarded *)rewardedAd ad:(BoldwinAd *)ad {
    // Called when ad is loaded.
    [self.showButton setEnabled:YES];
    [self.reloadButton setEnabled:YES];
}

- (void)rewardedAd:(BoldwinRewarded *)rewardedAd didFailToReceiveAdWithError:(BoldwinError *)error {
    // Called when Boldwin SDK failed to load ad.
    NSLog(@"SDK did fail to receive ad with error: %@", error.localizedDescription);
    [self.reloadButton setEnabled:YES];
}

- (void)rewardedAdUserDidEarnReward:(BoldwinRewarded *)rewardedAd reward:(BoldwinReward *)reward {
    // Called when the reward was granted to user.
    NSLog(@"User did earn reward.");
}

- (void)rewardedAdWillPresentAd:(BoldwinRewarded *)rewardedAd {
    // Called when rewarded ad is about to be presented.
}

- (void)rewardedAdDidDismissAd:(BoldwinRewarded *)rewardedAd {
    // Called when rewarded ad is dismissed.
}

- (void)rewardedAdDidClickAd:(BoldwinRewarded *)rewardedAd {
    // Called when rewarded ad was clicked.
}

- (void)rewardedAdWillLeaveApplication:(BoldwinRewarded *)rewardedAd {
    // Called when the application is about to enter the background.
}

@end
