/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "IronSourceBannerAdViewController.h"

@interface IronSourceBannerAdViewController ()

@property (nonatomic, strong, nullable) LPMBannerAdView * isAdView;

@end

@implementation IronSourceBannerAdViewController

- (NSString *)adUnitID {
    return @"ydlnsf65myak6ryz";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    CGSize size = CGSizeMake(300, 250);
    LPMBannerAdViewConfigBuilder * builder = [LPMBannerAdViewConfigBuilder new];
    LPMAdSize * adSize = [LPMAdSize customSizeWithWidth:size.width height:size.height];
    
    [builder setWithAdSize:adSize];
    LPMBannerAdViewConfig * config = [builder build];
    
    LPMBannerAdView * isAdView = [[LPMBannerAdView alloc] initWithAdUnitId:self.adUnitID config:config];
    isAdView.frame = CGRectMake(0, 0, size.width, size.height);
    [isAdView setDelegate:self];
    
    self.isAdView = isAdView;
    [self.containerView addSubview:isAdView];
    
    [isAdView loadAdWithViewController:self];
}

- (void)reload {
    [super reload];
    
    [self.isAdView removeFromSuperview];
    self.isAdView = nil;
    
    [self createAd];
}

# pragma mark - LPMBannerAdViewDelegate

- (void)didLoadAdWithAdInfo:(LPMAdInfo *)adInfo {
    [self.reloadButton setEnabled:YES];
}

- (void)didFailToLoadAdWithAdUnitId:(NSString *)adUnitId error:(NSError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"ironSource did fail to load ad with error:%@", error.localizedDescription);
}

- (void)didFailToDisplayAdWithAdInfo:(LPMAdInfo *)adInfo error:(NSError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"ironSource did fail to display ad with error:%@", error.localizedDescription);
}

- (void)didDisplayAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didClickAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didExpandAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didCollapseAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didLeaveAppWithAdInfo:(LPMAdInfo *)adInfo {}

@end
