/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "IronSourceMultiformatInterstitialController.h"

@interface IronSourceMultiformatInterstitialController ()

@property (nonatomic, strong, nullable) LPMInterstitialAd * isInterstitialAd;

@end

@implementation IronSourceMultiformatInterstitialController

- (NSString *)adUnitID {
    return @"yxhpax6m6xgzkt2e";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    LPMInterstitialAd * isInterstitialAd = [[LPMInterstitialAd alloc] initWithAdUnitId:self.adUnitID];
    [isInterstitialAd setDelegate:self];
    
    self.isInterstitialAd = isInterstitialAd;
    
    [self.isInterstitialAd loadAd];
}

- (void)reload {
    [super reload];
    
    self.isInterstitialAd = nil;
    [self createAd];
}

- (void)showAd {
    [super showAd];
    
    if (self.isInterstitialAd && self.isInterstitialAd.isAdReady == YES) {
        [self.isInterstitialAd showAdWithViewController:self placementName:nil];
    }
}

#pragma mark - LPMInterstitialAdDelegate

- (void)didLoadAdWithAdInfo:(LPMAdInfo *)adInfo {
    [self.reloadButton setEnabled:YES];
    [self.showButton setEnabled:YES];
}

- (void)didFailToLoadAdWithAdUnitId:(NSString *)adUnitId error:(NSError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"ironSource did fail to load ad with error: %@", error.localizedDescription);
}

- (void)didFailToDisplayAdWithAdInfo:(LPMAdInfo *)adInfo error:(NSError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"ironSource did fail to display ad with error: %@", error.localizedDescription);
}

- (void)didDisplayAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didClickAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didCloseAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didChangeAdInfo:(LPMAdInfo *)adInfo {}

@end
