/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "IronSourceMultiformatRewardedController.h"

@interface IronSourceMultiformatRewardedController ()

@property (nonatomic, strong, nullable) LPMRewardedAd * isRewardedAd;

@end

@implementation IronSourceMultiformatRewardedController

- (NSString *)adUnitID {
    return @"lsppopbi0w1vk82q";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self createAd];
}

- (void)createAd {
    LPMRewardedAd * isRewardedAd = [[LPMRewardedAd alloc] initWithAdUnitId:self.adUnitID];
    [isRewardedAd setDelegate:self];
    
    self.isRewardedAd = isRewardedAd;
    
    [self.isRewardedAd loadAd];
}

- (void)reload {
    [super reload];
    
    self.isRewardedAd = nil;
    
    [self createAd];
}

- (void)showAd {
    [super showAd];
    
    if (self.isRewardedAd && self.isRewardedAd.isAdReady == YES) {
        [self.isRewardedAd showAdWithViewController:self placementName:nil];
    }
}

#pragma mark - LPMRewardedAdDelegate

- (void)didLoadAdWithAdInfo:(LPMAdInfo *)adInfo {
    [self.reloadButton setEnabled:YES];
    [self.showButton setEnabled:YES];
}

- (void)didFailToLoadAdWithAdUnitId:(NSString *)adUnitId error:(NSError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"ironSource did fail to load ad with error: %@", error.localizedDescription);
}

- (void)didFailToDisplayAdWithAdInfo:(LPMAdInfo *)adInfo error:(NSError *)error {
    [self.reloadButton setEnabled:YES];
    NSLog(@"ironSource did fail to display ad with error: %@", error.localizedDescription);
}

- (void)didRewardAdWithAdInfo:(LPMAdInfo *)adInfo reward:(LPMReward *)reward {
    NSLog(@"User did get reward.");
}

- (void)didDisplayAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didClickAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didCloseAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didChangeAdInfo:(LPMAdInfo *)adInfo {}

@end
