/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

#import "TestCasesManager.h"

@implementation TestCasesManager

+ (NSArray<TestCase *> *)allCases {
    
    return @[
        [
            [TestCase alloc]
            initWithTitle:@"Banner Ad View 300x250 [Boldwin]"
            integrationKind:IntegrationKindSDK
            adFormats:@[@(AdFormatBanner)]
            configurationClosure:^UIViewController * _Nonnull {
                return [BoldwinBannerAdViewController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Multiformat Interstitial [Boldwin]"
            integrationKind:IntegrationKindSDK
            adFormats:@[@(AdFormatBanner), @(AdFormatVideo)]
            configurationClosure:^UIViewController * _Nonnull {
                return [BoldwinMultiformatInterstitialController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Multiformat Rewarded [Boldwin]"
            integrationKind:IntegrationKindSDK
            adFormats:@[@(AdFormatBanner), @(AdFormatVideo)]
            configurationClosure:^UIViewController * _Nonnull {
                return [BoldwinMultiformatRewardedController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Banner Ad View 300x250 [AppLovin MAX]"
            integrationKind:IntegrationKindMAX
            adFormats:@[@(AdFormatBanner)]
            configurationClosure:^UIViewController * _Nonnull {
                return [AppLovinBannerAdViewController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Multiformat Interstitial [AppLovin MAX]"
            integrationKind:IntegrationKindMAX
            adFormats:@[@(AdFormatBanner), @(AdFormatVideo)]
            configurationClosure:^UIViewController * _Nonnull {
                return [AppLovinMultiformatInterstitialController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Multiformat Rewarded [AppLovin MAX]"
            integrationKind:IntegrationKindMAX
            adFormats:@[@(AdFormatBanner), @(AdFormatVideo)]
            configurationClosure:^UIViewController * _Nonnull {
                return [AppLovinMultiformatRewardedViewController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Banner Ad View 300x250 [ironSource]"
            integrationKind:IntegrationKindIronSource
            adFormats:@[@(AdFormatBanner)]
            configurationClosure:^UIViewController * _Nonnull {
                return [IronSourceBannerAdViewController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Multiformat Interstitial [ironSource]"
            integrationKind:IntegrationKindIronSource
            adFormats:@[@(AdFormatBanner), @(AdFormatVideo)]
            configurationClosure:^UIViewController * _Nonnull {
                return [IronSourceMultiformatInterstitialController new];
            }
        ],
        
        [
            [TestCase alloc]
            initWithTitle:@"Multiformat Rewarded [ironSource]"
            integrationKind:IntegrationKindIronSource
            adFormats:@[@(AdFormatBanner), @(AdFormatVideo)]
            configurationClosure:^UIViewController * _Nonnull {
                return [IronSourceMultiformatRewardedController new];
            }
        ],
    ];
}

@end
