/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit

import Boldwin

import AppLovinSDK
import IronSource

@main
class AppDelegate: UIResponder, UIApplicationDelegate {

    func application(
        _ application: UIApplication,
        didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?
    ) -> Bool {
        initializeBoldwin()
        initApplovinSDK()
        initIronSource()
        
        return true
    }
    
    // MARK: SDK Initialization
    
    private func initializeBoldwin() {
        // Init SDK with respective publisher ID
        BoldwinSDK.initialize(publisherID: "2016")
    }
    
    private func initApplovinSDK() {
        let config = ALSdkInitializationConfiguration(
            sdkKey: "1tLUnP4cVQqpHuHH2yMtfdESvvUhTB05NdbCoDTceDDNVnhd_T8kwIzXDN9iwbdULTboByF-TtNaiTmsoVbxZw"
        )
        
        ALSdk.shared().initialize(with: config)
        ALSdk.shared().settings.isVerboseLoggingEnabled = true
    }
    
    private func initIronSource() {
        let requestBuilder = LPMInitRequestBuilder(appKey: "246e5ae05")
        let initRequest = requestBuilder.build()
        
        LevelPlay.initWith(initRequest) { _, error in
            if let error {
                print("ironSource: init failed with error: \(error)")
            }
        }
    }

    // MARK: UISceneSession Lifecycle

    func application(
        _ application: UIApplication,
        configurationForConnecting connectingSceneSession: UISceneSession,
        options: UIScene.ConnectionOptions
    ) -> UISceneConfiguration {
        return UISceneConfiguration(
            name: "Default Configuration",
            sessionRole: connectingSceneSession.role
        )
    }
}
