/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit

fileprivate let bannerBaseViewControllerNibName = "BannerBaseViewController"

class BannerBaseViewController: UIViewController {
    
    @IBOutlet weak var containerView: UIView!
    
    @IBOutlet weak var containerWidthConstraint: NSLayoutConstraint!
    @IBOutlet weak var containerHeightConstraint: NSLayoutConstraint!
    
    @IBOutlet weak var reloadButton: UIButton!
    
    var adSize = CGSize(width: 300, height: 250)
    
    convenience init(adSize: CGSize) {
        self.init(nibName: bannerBaseViewControllerNibName, bundle: nil)
        self.adSize = adSize
    }
    
    convenience init() {
        self.init(nibName: bannerBaseViewControllerNibName, bundle: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        containerWidthConstraint?.constant = adSize.width
        containerHeightConstraint?.constant = adSize.height
        
        reloadButton.addTarget(self, action: #selector(reload), for: .touchUpInside)
    }
    
    @objc func reload() {
        reloadButton.isEnabled = false
    }
}
