/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit

fileprivate let interstitialBaseViewControllerNibName = "InterstitialBaseViewController"

/// Base controller for interstitial integration cases
class InterstitialBaseViewController: UIViewController {
    
    @IBOutlet weak var showButton: UIButton!
    @IBOutlet weak var reloadButton: UIButton!
    
    convenience init() {
        self.init(nibName: interstitialBaseViewControllerNibName, bundle: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        reloadButton.addTarget(self, action: #selector(reload), for: .touchUpInside)
    }
    
    @objc func reload() {
        reloadButton.isEnabled = false
        showButton.isEnabled = false
    }
    
    @IBAction func showAd(_ sender: UIButton) {
        showButton.isEnabled = false
    }
}
