/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit
import AppLovinSDK

fileprivate let AD_UNIT_ID = "<AD_UNIT_ID>"

final class AppLovinBannerAdViewController: BannerBaseViewController {
    
    private var maAdView: MAAdView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        createAd()
    }
    
    private func createAd() {
        maAdView = MAAdView(adUnitIdentifier: AD_UNIT_ID, adFormat: .mrec)
         
        maAdView.delegate = self
        maAdView.frame = CGRect(origin: .zero, size: CGSize(width: 300, height: 250))
        
        containerView.addSubview(maAdView)
        
        maAdView.loadAd()
    }
    
    // MARK: Utils
    
    override func reload() {
        super.reload()
        
        maAdView.removeFromSuperview()
        maAdView = nil
        
        createAd()
    }
}

// MARK: - MAAdViewAdDelegate

extension AppLovinBannerAdViewController: MAAdViewAdDelegate {
    
    func didLoad(_ ad: MAAd) {
        reloadButton.isEnabled = true
    }
    
    func didFailToLoadAd(forAdUnitIdentifier adUnitIdentifier: String, withError error: MAError) {
        reloadButton.isEnabled = true
        print("Did fail to load ad with error: \(error.message)")
    }
    
    func didFail(toDisplay ad: MAAd, withError error: MAError) {
        reloadButton.isEnabled = true
        print("Did fail to display ad with error: \(error.message)")
    }
    
    func didExpand(_ ad: MAAd) {}
    func didCollapse(_ ad: MAAd) {}
    func didDisplay(_ ad: MAAd) {}
    func didHide(_ ad: MAAd) {}
    func didClick(_ ad: MAAd) {}
}
