/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit
import AppLovinSDK

fileprivate let AD_UNIT_ID = "<AD_UNIT_ID>"

final class AppLovinMultiformatRewardedViewController: InterstitialBaseViewController {
    
    private var rewardedAd: MARewardedAd!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        createAd()
    }
    
    private func createAd() {
        rewardedAd = MARewardedAd.shared(withAdUnitIdentifier: AD_UNIT_ID)
        
        rewardedAd.delegate = self
        
        rewardedAd.load()
    }
    
    // MARK: Utils
    
    override func reload() {
        super.reload()
        
        rewardedAd = nil
        
        createAd()
    }
}

// MARK: - MARewardedAdDelegate

extension AppLovinMultiformatRewardedViewController: MARewardedAdDelegate {
   
    func didLoad(_ ad: MAAd) {
        reloadButton.isEnabled = true
        
        if rewardedAd != nil && rewardedAd.isReady {
            rewardedAd.show()
        }
    }
   
    func didFailToLoadAd(forAdUnitIdentifier adUnitIdentifier: String, withError error: MAError) {
        reloadButton.isEnabled = true
        print("AppLovin did fail to load ad with error: \(error.message)")
    }
    
    func didFail(toDisplay ad: MAAd, withError error: MAError) {
        reloadButton.isEnabled = true
        print("AppLovin did fail to display ad with error: \(error.message)")
    }
    
    func didRewardUser(for ad: MAAd, with reward: MAReward) {
        print("User did earn reward - label: \(reward.label), amount: \(reward.amount)")
    }
    
    func didDisplay(_ ad: MAAd) {}
    func didHide(_ ad: MAAd) { }
    func didClick(_ ad: MAAd) {}
}
