/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit
import Boldwin

fileprivate let placementID = "686e42a0035b2ced064cc938"

final class BoldwinBannerAdViewController: BannerBaseViewController {
    
    private var boldwinAdView: BoldwinAdView?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        createAd()
    }
    
    private func createAd() {
        // 1. Create BoldwinAdView instance.
        let adSize = CGSize(width: 300, height: 250)
        let adView = BoldwinAdView(
            placementID: placementID,
            frame: CGRect(origin: .zero, size: adSize),
            adSizes: [
                BoldwinAdSize(width: Int(adSize.width), height: Int(adSize.height))
            ]
        )
        
        // 2. Optionally set delegates.
        adView.delegate = self
        adView.adSizeDelegate = self
        
        // 3. Configure BoldwinAdView.
        adView.autoRefreshPeriod = 15
        
        // Store the instance.
        boldwinAdView = adView
        
        // Add to UI.
        containerView.addSubview(adView)
        
        // 5. Load ad.
        adView.loadAd()
    }
    
    override func reload() {
        super.reload()
        
        boldwinAdView?.removeFromSuperview()
        boldwinAdView = nil
        createAd()
    }
}

// MARK: - BoldwinAdViewSizeDelegate
extension BoldwinBannerAdViewController: BoldwinAdViewSizeDelegate {
    
    func adView(
        _ adView: BoldwinAdView,
        willChangeAdSizeTo size: BoldwinAdSize
    ) {
        // Called when ad view changes size.
        // Use to update the layout respectively.
    }
}

// MARK: - BoldwinAdViewDelegate
extension BoldwinBannerAdViewController: BoldwinAdViewDelegate {
    
    func adViewPresentationController() -> UIViewController? {
        // Specify controller for modal presentation.
        self
    }
    
    func adView(_ adView: BoldwinAdView, didReceiveAd: BoldwinAd) {
        // Called when ad is loaded.
        reloadButton.isEnabled = true
    }
    
    func adView(_ adView: BoldwinAdView, didFailToReceiveAdWith error: BoldwinError) {
        // Called when Boldwin SDK failed to load ad.
        print("SDK did fail to receive ad with error: \(error.localizedDescription)")
        reloadButton.isEnabled = true
    }
    
    func adViewWillPresentModal(_ adView: BoldwinAdView) {
        // Called when modal is about to be presented.
    }
    
    func adViewDidDismissModal(_ adView: BoldwinAdView) {
        // Called when modal is dismissed.
    }
    
    func adViewWillLeaveApplication(_ adView: BoldwinAdView) {
        // Called when the application is about to enter the background.
    }
}
