/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit
import Boldwin

fileprivate let placementID = "686e42a0035b2ced064cc938"

final class BoldwinMultiformatInterstitialController: InterstitialBaseViewController {
    
    private var boldwinInterstitial: BoldwinInterstitial?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        createAd()
    }
    
    private func createAd() {
        // 1. Create BoldwinInterstitial instance.
        let interstitial = BoldwinInterstitial(placementID: placementID)
        
        // 2. Optionally set delegates
        interstitial.delegate = self
        
        // Store instance
        self.boldwinInterstitial = interstitial
        
        // 3. Load ad.
        interstitial.loadAd()
    }
    
    override func showAd(_ sender: UIButton) {
        super.showAd(sender)
        
        // 4. Check if ad is ready to be displayed.
        if boldwinInterstitial?.isReady == true {
            
            // 5. Show the ad.
            boldwinInterstitial?.show(from: self)
        }
    }
    
    override func reload() {
        super.reload()
        
        boldwinInterstitial = nil
        createAd()
    }
}

// MARK: - BoldwinInterstitialDelegate
extension BoldwinMultiformatInterstitialController: BoldwinInterstitialDelegate {
    
    func interstitialDidReceiveAd(
        _ interstitial: BoldwinInterstitial,
        ad: BoldwinAd
    ) {
        // Called when ad is loaded.
        showButton.isEnabled = true
        reloadButton.isEnabled = true
    }
    
    func interstitial(
        _ interstitial: BoldwinInterstitial,
        didFailToReceiveAdWithError error: BoldwinError?
    ) {
        // Called when Boldwin SDK failed to load ad.
        print("SDK did fail to load ad with error: \(String(describing: error?.localizedDescription))")
        reloadButton.isEnabled = true
    }
    
    func interstitialWillPresentAd(_ interstitial: BoldwinInterstitial) {
        // Called when interstitial is about to be presented.
    }
    
    func interstitialDidDismissAd(_ interstitial: BoldwinInterstitial) {
        // Called when interstitial is dismissed.
    }
    
    func interstitialDidClickAd(_ interstitial: BoldwinInterstitial) {
        // Called when interstitial was clicked.
    }
    
    func interstitialWillLeaveApplication(_ interstitial: BoldwinInterstitial) {
        // Called when the application is about to enter the background.
    }
}
