/*
 © 2025 BOLDWIN LTD.  All rights reserved.
 You may not use this file except in compliance with the applicable license granted to you by BOLDWIN LTD.
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 Specific authorizations and restrictions shall be provided for in the License.
 */

import UIKit
import Boldwin

fileprivate let placementID = "686e42a0035b2ced064cc938"

final class BoldwinMultiformatRewardedController: InterstitialBaseViewController {
    
    private var boldwinRewarded: BoldwinRewarded?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        createAd()
    }
    
    private func createAd() {
        // 1. Create BoldwinRewarded instance.
        let rewarded = BoldwinRewarded(
            placementID: placementID
        )
        
        // 2. Optionally set delegate.
        rewarded.delegate = self
        
        // Store instance.
        self.boldwinRewarded = rewarded
        
        // 3. Load the ad.
        rewarded.loadAd()
    }
    
    override func showAd(_ sender: UIButton) {
        super.showAd(sender)
        
        // 4. Check if the ad is ready to be displayed.
        if boldwinRewarded?.isReady == true {
            // 5. Show the ad.
            boldwinRewarded?.show(from: self)
        }
    }
}

// MARK: - BoldwinRewardedDelegate
extension BoldwinMultiformatRewardedController: BoldwinRewardedDelegate {
    
    func rewardedAdDidReceiveAd(
        _ rewardedAd: BoldwinRewarded,
        ad: BoldwinAd
    ) {
        // Called when ad is loaded.
        showButton.isEnabled = true
        reloadButton.isEnabled = true
    }
    
    func rewardedAd(
        _ rewardedAd: BoldwinRewarded,
        didFailToReceiveAdWithError error: BoldwinError?
    ) {
        // Called when Boldwin SDK failed to load ad.
        print("Did fail to receive ad with error: \(String(describing: error?.localizedDescription))")
        reloadButton.isEnabled = true
    }
    
    func rewardedAdUserDidEarnReward(
        _ rewardedAd: BoldwinRewarded,
        reward: BoldwinReward
    ) {
        // Called when the reward was granted to user
        print("User did earn reward.")
    }
    
    func rewardedAdWillPresentAd(_ rewardedAd: BoldwinRewarded) {
        // Called when rewarded ad is about to be presented.
    }
    
    func rewardedAdDidDismissAd(_ rewardedAd: BoldwinRewarded) {
        // Called when rewarded ad is dismissed.
    }
    
    func rewardedAdDidClickAd(_ rewardedAd: BoldwinRewarded) {
        // Called when rewarded ad was clicked.
    }
    
    func rewardedAdWillLeaveApplication(_ rewardedAd: BoldwinRewarded) {
        // Called when the application is about to enter the background.
    }
}
